/********************************************************************************
 		Remote Control State Machine
		Mauro Grassi May 2008 for Musicolour BETA ver 8.0 and above
 		based on code by Peter Smith
		Infrared receive state machine (must be called every 64us)
*********************************************************************************/
#ifndef	_IR_H
#define _IR_H

#define IR_RXD	PORTBbits.RB4

/*
RC5 Specification Periods:

short pulse	889s	444s	1333s
short space	889s	444s	1333s
long pulse	1778s	1334s	2222s
long space	1778s	1334s	2222s

Version 5.00 is for AR1725 remote control with VCR 115 code default
Version 5.01 is for AR1726 remote control with VCR 917 code	default

*/
#define VERHIGH						5
#define VERLOW						1
#define VERSION                     501
//
#define KEY_BUFFER_SIZE             4
#define DEFAULT_TIMEOUT_PERIOD		0   // in minutes... 0=disabled
#define MINOR_DELAY					3
#define BLINK_DELAY					65
#define MAJOR_DELAY				    100
#define BLINKDIGIT_DELAY			150
// EEPROM addresses
// Version EEPROM Addresses
#define	REMOTE_CONTROL_DEFS_ADDRESS 0
#define MAGIC_REMOTE_CONTROL_VALUE  0x76
#define VERHIGH_ADR                 0x80
#define VERLOW_ADR                  0x81
#define LAMPBRIGHTNESS_ADR	        0xC0
#define MODE_ADR                    0xC1
#define FLASHMODULUS_ADR			0xC2
#define TIMEOUTHI_ADR				0xC3
#define TIMEOUTLO_ADR				0xC4
#define QUIESCENT_ADR				0xC5
#define ADDRESS_ADR					0xC6
#define LIMITING0_ADR				0xC7
#define LIMITING1_ADR				0xC8
//
#define OFFSETHI_ADR				0xC9
#define OFFSETLO_ADR				0xCA
#define OFFSET1HI_ADR				0xCB
#define OFFSET1LO_ADR				0xCC
#define LOOPDELAY_ADR               0xCD
//
#define SAVEBRIGHTNESS_ADR			0xD0
#define SAVEMODE_ADR				0xD1
// Menus
#define MENU_RESET                  0
#define MENU_TIMEOUTPERIOD			1
#define MENU_FLASHMODULUS			2
#define MENU_QUIESCENT				3
#define MENU_ADDRESS				4
#define MENU_LIMITING0				5
#define MENU_LIMITING1				6
#define MENU_OFFSET					7
#define MENU_OFFSET1				8
#define MENU_LOOPDELAY              9
// Info menus
#define INFO_VERSION				0
#define INFO_TIMEOUTPERIOD			1
#define INFO_FLASHMODULUS			2
#define INFO_MAINSFREQ				3
#define INFO_ADDRESS				4
#define INFO_LIMITING0				5
#define INFO_LIMITING1				6
#define INFO_OFFSET					7
#define INFO_OFFSET1				8
#define INFO_LOOPDELAY              9
//
#define FLASH_MODULUS	            10          // this is the default value
//
#define KEYZERO 	        1
#define KEYONE		        2
#define KEYTWO	        	3
#define KEYTHREE	        4
#define KEYFOUR		        5
#define KEYFIVE	        	6
#define KEYSIX		        7
#define KEYSEVEN	        8
#define KEYEIGHT        	9
#define KEYNINE		        10
#define KEYDIMUP	        11
#define KEYDIMDOWN	        12
#define KEYMODEUP	        13
#define KEYMODEDOWN	        14
#define KEYTOGGLE	        15			// this should be higher than 11 for the enternumber ack LED to work properly!
#define KEYMENU		        16
#define KEYINFO		        17
#define KEYOK		        18
#define KEYPLAY		        19
#define KEYRECORD	        20
#define IRKEYS 		        20
//
#define STARTUP_DELAY		400
#define MAINSTARTUP_DELAY	100
#define PROGRAM_DELAY   	500
//
#define THIRTY_ONE      	31
#define SEVENTY_EIGHT   	78
#define THIRTY_FIVE     	35
#define TWENTY_ONE      	21
#define REPEAT_TIMES		1
//
#define GLED1	LATAbits.LATA0
#define RLED1	LATAbits.LATA1
#define BLED1	LATAbits.LATA2
#define GLED2	LATAbits.LATA3
#define BLED2	LATBbits.LATB1
#define RLED2	LATAbits.LATA4
#define RED1	0
#define GREEN1	1
#define BLUE1	2
#define RED2	3
#define GREEN2	4
#define BLUE2	5
//
#define INPUTBOOT	PORTBbits.RB6
#define OUTPUTBOOT	LATBbits.LATB7
//
#define LEDSOFFA	(0x1F)
#define LEDSOFFB	(0x02)
//
#define IRSYSTEMON					1
#define LIGHTSYSTEMON				1
#define IRSERVICEHIGH				0
#define PULSE_PERIOD				(15*2)			// determines the pulse positive on period for the trigger to the Triac
#define FIXED_DENOMINATOR			(5200*2)
#define DEFAULT_LIMITING0			255
#define DEFAULT_LIMITING1			255
#define MAX_PHASE_OFFSET			(5200*2)		// absolute maximum offset applied to the second stage of output compare matching
//
#define DEFAULT_LOOPDELAY           5
#define DIMMING_LEVELS				256
#define TARGET_MODULUS				0xFF
//
#define FULLYOFF					0
#define FULLYON						255
#define ZV_THRESHOLD				20	// less than 11 percent brightness threshold
// the following are operational modes
#define NO_MODE						0
#define ZV_MODE						1
#define BABY_MODE					2
#define FLASHING_MODE				3
#define RANDOM_MODE					4
#define ALL_MODES					5
//
typedef unsigned char byte;
extern byte keyFull;
extern byte ir_timer;
extern unsigned char ir_state, ir_bit_cnt;
extern int ir_cmd, ir_code;
extern unsigned char ir_rpt;
extern byte ir_rdy;
extern void initRC5(void);
extern int ir_receive(void);
extern byte translateIRCode(byte);
extern int ReadEEPROM(byte);
extern byte WriteEEPROM(byte, byte);
extern void blinkColour(byte, byte);
extern void DelayTenthMs(int);
extern void blinkString(rom char*);
extern void blinkKey(byte, byte);
extern void ackKey(void);
extern int key;
extern rom char enterMenuString[];
extern rom char exitMenuString[];
extern void initKeys(void);
extern byte getKey(void);
//extern byte noKeys(void);
extern void putKey(byte);
extern void blinkNumber(int, byte);
#endif


